/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.browser;

import com.aptana.browser.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class CustomSizeDialog
extends TitleAreaDialog {
    private Text fWidthText;
    private Text fHeightText;
    int fWidth;
    int fHeight;

    protected CustomSizeDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.WebBrowserViewer_CustomSize_Title);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.validate();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        main.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        new Label(main, 0).setText(Messages.WebBrowserViewer_LBL_Width);
        this.fWidthText = new Text(main, 2052);
        this.fWidthText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomSizeDialog.this.validate();
            }
        };
        this.fWidthText.addModifyListener(listener);
        new Label(main, 0).setText(Messages.WebBrowserViewer_LBL_Height);
        this.fHeightText = new Text(main, 2052);
        this.fHeightText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.fHeightText.addModifyListener(listener);
        this.setTitle(Messages.WebBrowserViewer_CustomSize_Title);
        this.setMessage(Messages.WebBrowserViewer_CustomSize_Message);
        return main;
    }

    protected void okPressed() {
        this.fWidth = Integer.parseInt(this.fWidthText.getText());
        this.fHeight = Integer.parseInt(this.fHeightText.getText());
        super.okPressed();
    }

    private void validate() {
        String message = null;
        String text = this.fWidthText.getText();
        if (text.trim().length() == 0) {
            message = Messages.WebBrowserViewer_ERR_InvalidWidth;
        } else {
            try {
                int width = Integer.parseInt(text);
                if (width <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                message = Messages.WebBrowserViewer_ERR_InvalidWidth;
            }
        }
        if (message == null) {
            text = this.fHeightText.getText();
            if (text.trim().length() == 0) {
                message = Messages.WebBrowserViewer_ERR_InvalidHeight;
            } else {
                try {
                    int height = Integer.parseInt(text);
                    if (height <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    message = Messages.WebBrowserViewer_ERR_InvalidHeight;
                }
            }
        }
        this.setErrorMessage(message);
        this.getButton(0).setEnabled(message == null);
    }
}

